<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Common;
use App\Models\Quiz_Configuration;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Exception;

class QuizConfigurationController extends Controller
{
    public $common;
    public function __construct()
    {
        $this->common = new Common;
    }

    public function index()
    {
        try {

            $params['data'] = Quiz_Configuration::orderByDesc('quiz_status')->where('status', 1)->get();
            return view('admin.quiz_configuration.index', $params);
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function show($id)
    {
        try {

            $data = Quiz_Configuration::where('id', $id)->first();
            if (isset($data)) {

                $data['quiz_status'] = $data['quiz_status'] === 1 ? 0 : 1;
                $data->save();
                return response()->json(['status' => 200, 'success' => __('label.status_changed'), 'status_code' => $data['quiz_status']]);
            } else {
                return response()->json(['status' => 400, 'errors' => __('label.data_not_found')]);
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function edit($id)
    {
        try {

            $params['result'] = Quiz_Configuration::where('id', $id)->first();
            if (isset($params['result']['id'])) {
                return view('admin.quiz_configuration.edit', $params);
            } else {
                return redirect()->back()->with('error', __('label.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function update($id, Request $request)
    {
        try {
            $rules = [
                'id' => 'required',
            ];
            if (in_array($request['id'], [1, 2, 3, 4, 5, 6])) {
                $rules['category_status'] = 'required';
                $rules['skill_status'] = 'required';
                $rules['classification_status'] = 'required';
                $rules['level_status'] = 'required';
                $rules['total_questions'] = 'required|numeric|min:1';
                $rules['quiz_duration'] = 'required|numeric|min:1';
            }
            if (in_array($request['id'], [2, 3, 4, 5, 6])) {
                $rules['joining_type'] = 'required';
                $rules['winning_coin_type'] = 'required';
            }
            if ($request['id'] == 9) {
                $rules['total_questions'] = 'required|numeric|min:1';
                $rules['quiz_duration'] = 'required|numeric|min:1';
            }
            if (in_array($request['id'], [10, 11])) {
                $rules['battles_commission'] = 'required|numeric|min:0|max:100';
            }
            if ($request['id'] == 11) {
                $rules['min_user_join'] = 'required|numeric|min:3';
                $rules['max_user_join'] = 'required|numeric|min:3';
            }
            $validator = Validator::make($request->all(), $rules);
            if ($validator->fails()) {
                $errs = $validator->errors()->all();
                return response()->json(['status' => 400, 'errors' => $errs]);
            }

            $quiz = Quiz_Configuration::where('id', $request['id'])->first();
            if ($quiz) {

                if (in_array($request['id'], [1, 2, 3, 4, 5, 6])) {
                    $quiz['category_status'] = $request['category_status'];
                    $quiz['skill_status'] = $request['skill_status'];
                    $quiz['classification_status'] = $request['classification_status'];
                    $quiz['level_status'] = $request['level_status'];
                    $quiz['quiz_sort_order'] = $request['quiz_sort_order'] ?? "";
                    $quiz['total_questions'] = $request['total_questions'];
                    $quiz['quiz_duration'] = $request['quiz_duration'];
                    $quiz['min_winning_percentage'] = $request['min_winning_percentage'] ?? 0;
                }
                if (in_array($request['id'], [2, 3, 4, 5, 6])) {
                    $quiz['joining_type'] = $request['joining_type'];
                    $quiz['joining_coin'] = $request['joining_coin'] ?? 0;
                    $quiz['winning_coin_type'] = $request['winning_coin_type'];
                    $quiz['winning_coin'] = $request['winning_coin'] ?? 0;
                }
                if ($request['id'] == 9) {
                    $quiz['total_questions'] = $request['total_questions'];
                    $quiz['quiz_duration'] = $request['quiz_duration'];
                    $quiz['min_winning_percentage'] = $request['min_winning_percentage'] ?? 0;
                    $quiz['winning_coin'] = $request['winning_coin'] ?? 0;
                    $quiz['joining_coin'] = $request['joining_coin'] ?? 0;
                }
                if (in_array($request['id'], [10, 11])) {
                    $quiz['battles_commission'] = $request['battles_commission'] ?? 0;
                }
                if ($request['id'] == 11) {
                    $quiz['min_user_join'] = $request['min_user_join'] ?? 0;
                    $quiz['max_user_join'] = $request['max_user_join'] ?? 0;
                }

                if ($quiz->save()) {
                    return response()->json(['status' => 200, 'success' => __('label.configuration_save_successfully')]);
                } else {
                    return response()->json(['status' => 400, 'errors' => __('label.error_edit_quiz_configuration')]);
                }
            } else {
                return response()->json(['status' => 400, 'errors' => __('label.data_not_found')]);
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
}
